/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.jupiter;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestInstancePreDestroyCallback;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import uk.org.webcompere.systemstubs.jupiter.SystemStub;
import uk.org.webcompere.systemstubs.resource.Resources;
import uk.org.webcompere.systemstubs.resource.TestResource;

public class SystemStubsExtension
implements TestInstancePostProcessor,
TestInstancePreDestroyCallback,
ParameterResolver,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private LinkedList<TestResource> activeResources = new LinkedList();

    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) throws Exception {
        this.setupFields(testInstance.getClass(), testInstance, SystemStubsExtension.not(SystemStubsExtension::isStaticField));
    }

    public void preDestroyTestInstance(ExtensionContext extensionContext) throws Exception {
        Object testInstance = extensionContext.getTestInstance().get();
        this.cleanupFields(testInstance.getClass(), testInstance, SystemStubsExtension.not(SystemStubsExtension::isStaticField));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return TestResource.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        try {
            TestResource resource = (TestResource)parameterContext.getParameter().getType().newInstance();
            resource.setup();
            this.activeResources.addFirst(resource);
            return resource;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ParameterResolutionException("Failure to call default constructor of TestResource of type " + parameterContext.getParameter().getType().getCanonicalName() + ". The type should have a public default constructor.", (Throwable)e);
        }
        catch (Exception e) {
            throw new ParameterResolutionException("Cannot start test resource: " + e.getMessage(), (Throwable)e);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Resources.executeCleanup(this.activeResources);
        this.activeResources.clear();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.cleanupFields(context.getRequiredTestClass(), null, SystemStubsExtension::isStaticField);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.setupFields(context.getRequiredTestClass(), null, SystemStubsExtension::isStaticField);
    }

    private void setup(Field field, Object testInstance) throws Exception {
        if (!TestResource.class.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("Cannot use @SystemStub with non TestResource object");
        }
        SystemStubsExtension.makeAccessible(field);
        this.getInstantiatedTestResource(field, testInstance).setup();
    }

    private TestResource getInstantiatedTestResource(Field field, Object testInstance) {
        return SystemStubsExtension.tryToReadFieldValue(field, testInstance).toOptional().map(val -> (TestResource)val).orElseGet(() -> this.assignNewInstanceToField(field, testInstance));
    }

    private TestResource assignNewInstanceToField(Field field, Object testInstance) {
        try {
            TestResource resource = (TestResource)field.getType().newInstance();
            field.set(testInstance, resource);
            return resource;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private void setupFields(Class<?> clazz, Object testInstance, Predicate<Field> predicate) throws Exception {
        for (Field field : this.findSystemStubsFields(clazz, predicate)) {
            this.setup(field, testInstance);
        }
    }

    private List<Field> findSystemStubsFields(Class<?> clazz, Predicate<Field> predicate) {
        Predicate<Field> annotated = field -> field.isAnnotationPresent(SystemStub.class);
        return ReflectionSupport.findFields(clazz, annotated.and(predicate), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
    }

    private void cleanupFields(Class<?> clazz, Object testInstance, Predicate<Field> predicate) throws Exception {
        LinkedList active = new LinkedList();
        this.findSystemStubsFields(clazz, predicate).stream().map(field -> SystemStubsExtension.tryToReadFieldValue(field, testInstance).toOptional()).filter(Optional::isPresent).map(Optional::get).map(TestResource.class::cast).forEach(active::addFirst);
        Resources.executeCleanup(active);
    }

    private static boolean isStaticField(Field f) {
        return Modifier.isStatic(f.getModifiers());
    }

    private static <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    private static <T extends AccessibleObject> T makeAccessible(T object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
        return object;
    }

    private static Try<Object> tryToReadFieldValue(Field field, Object instance) {
        return Try.call(() -> SystemStubsExtension.makeAccessible(field).get(instance));
    }
}

