/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.ast;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class NodeIterator
implements ReversiblePeekingIterator<Node> {
    final Node firstNode;
    final Node lastNode;
    final boolean reversed;
    Node node;
    Node result;
    public static final ReversiblePeekingIterator<Node> EMPTY = new ReversiblePeekingIterator<Node>(){

        public void remove() {
        }

        public boolean isReversed() {
            return false;
        }

        public boolean hasNext() {
            return false;
        }

        public Node next() {
            throw new NoSuchElementException();
        }

        @Nullable
        public Node peek() {
            return null;
        }
    };

    public NodeIterator(Node firstNode) {
        this(firstNode, null, false);
    }

    public NodeIterator(Node firstNode, boolean reversed) {
        this(firstNode, null, reversed);
    }

    public NodeIterator(Node firstNode, Node lastNode) {
        this(firstNode, lastNode, false);
    }

    public NodeIterator(Node firstNode, Node lastNode, boolean reversed) {
        if (firstNode == null) {
            throw new NullPointerException();
        }
        this.firstNode = firstNode;
        this.lastNode = lastNode;
        this.reversed = reversed;
        this.node = reversed ? lastNode : firstNode;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public boolean hasNext() {
        return this.node != null;
    }

    public Node next() {
        this.result = null;
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        this.result = this.node;
        Node node = this.node = this.reversed ? this.node.getPrevious() : this.node.getNext();
        if (this.node == null || this.result == (this.reversed ? this.firstNode : this.lastNode)) {
            this.node = null;
        }
        return this.result;
    }

    @Nullable
    public Node peek() {
        if (this.node != null) {
            return this.node;
        }
        return null;
    }

    public void remove() {
        if (this.result == null) {
            throw new IllegalStateException("Either next() was not called yet or the node was removed");
        }
        this.result.unlink();
        this.result = null;
    }

    public void forEachRemaining(Consumer<? super Node> consumer) {
        if (consumer == null) {
            throw new NullPointerException();
        }
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }
}

