/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.live;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import org.netbeans.insane.hook.MakeAccessible;
import org.netbeans.insane.impl.Root;
import org.netbeans.insane.impl.Utils;

public final class Path {
    private Object item;
    private Path nextElement;

    private Path(Object object, Path path) {
        this.item = object;
        this.nextElement = path;
    }

    public Object getObject() {
        return this.item;
    }

    public Path nextNode() {
        return this.nextElement;
    }

    public String describeReference() {
        return this.getField();
    }

    public static String describeObject(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Class) {
            return object.toString() + "@" + Integer.toHexString(System.identityHashCode(object));
        }
        return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    public String toString() {
        if (this.nextElement == null) {
            return Path.describeObject(this.item);
        }
        if (this.item instanceof Root) {
            return ((Root)this.item).describe() + "->\n" + this.nextElement.toString();
        }
        return Path.describeObject(this.item) + "-" + this.getField() + "->\n" + this.nextElement.toString();
    }

    private String getField() {
        Object object = this.nextElement.item;
        Class<?> clazz = this.item.getClass();
        if (clazz.isArray()) {
            assert (!clazz.getComponentType().isPrimitive());
            Object[] objectArray = (Object[])this.item;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != object) continue;
                return "[" + i + "]";
            }
            return "<changed>";
        }
        while (clazz != null) {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                try {
                    Field field = fieldArray[i];
                    if (field.getType().isPrimitive() || (field.getModifiers() & 8) != 0) continue;
                    MakeAccessible.setAccessible((AccessibleObject)field, (boolean)true);
                    if (object != field.get(this.item)) continue;
                    return field.getName();
                }
                catch (Exception exception) {
                    return "<error>";
                }
            }
            clazz = clazz.getSuperclass();
        }
        return "<changed>";
    }

    public int hashCode() {
        return System.identityHashCode(this.item);
    }

    public boolean equals(Object object) {
        return object instanceof Path && ((Path)object).item == this.item;
    }

    static {
        Utils.PATH_FACTORY = new Utils.PathFactory(){

            @Override
            public Path createPath(Object object, Path path) {
                return new Path(object, path);
            }
        };
    }
}

