/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public class ArtifactFile {
    private String name;
    private String classifier;
    private String extension;

    public ArtifactFile(File file, @Nullable String version) {
        this(file.getName(), version);
    }

    public ArtifactFile(String fileBaseName, @Nullable String version) {
        int startVersion;
        this.name = fileBaseName;
        this.extension = "";
        this.classifier = "";
        boolean done = false;
        if (version != null && (startVersion = StringUtils.lastIndexOf((CharSequence)this.name, (CharSequence)("-" + version))) >= 0) {
            int endVersion = startVersion + version.length() + 1;
            if (endVersion == this.name.length()) {
                this.name = this.name.substring(0, startVersion);
                done = true;
            } else if (endVersion < this.name.length() && this.name.charAt(endVersion) == '-') {
                String tail = this.name.substring(endVersion + 1);
                this.name = this.name.substring(0, startVersion);
                this.classifier = StringUtils.substringBeforeLast((String)tail, (String)".");
                this.extension = StringUtils.substringAfterLast((String)tail, (String)".");
                done = true;
            } else if (endVersion < this.name.length() && StringUtils.lastIndexOf((CharSequence)this.name, (CharSequence)".") == endVersion) {
                this.extension = this.name.substring(endVersion + 1);
                this.name = this.name.substring(0, startVersion);
                done = true;
            }
        }
        if (!done) {
            this.extension = StringUtils.substringAfterLast((String)this.name, (String)".");
            this.name = StringUtils.substringBeforeLast((String)this.name, (String)".");
        }
        if (this.classifier.length() == 0) {
            this.classifier = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }
}

